﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Text;
using System.Windows.Forms;
using System.IO;

namespace Elatec
{
    public abstract class Logger
    {
        public abstract void Write(string Text);
        public abstract void WriteLine(string Text);
        public void WriteStream(StreamReader sr)
        {
            while (!sr.EndOfStream)
                WriteLine(sr.ReadLine());
        }
    }

    delegate int IntAction();

    class ThreadSaveListBox
    {
        ListBox listBox;
        public ThreadSaveListBox(ListBox listBox)
        {
            this.listBox = listBox;
        }
        public void Clear()
        {
            if (listBox.InvokeRequired)
            {
                Action DoAction = delegate() { Clear(); };
                listBox.Invoke(DoAction);
            }
            else
                listBox.Items.Clear();
        }
        public void AddItem(string Item)
        {
            if (listBox.InvokeRequired)
            {
                Action<string> DoAction = delegate(string s) { AddItem(s); };
                listBox.Invoke(DoAction, new object[] { Item });
            }
            else
                listBox.Items.Add(Item);
        }
        public void SetItem(int Index,string Item)
        {
            if (listBox.InvokeRequired)
            {
                Action<int, string> DoAction = delegate(int i, string s) { SetItem(i, s); };
                listBox.Invoke(DoAction, new object[] { Index, Item });
            }
            else
                listBox.Items[Index] = Item;
        }
        public void RemoveAt(int Index)
        {
            if (listBox.InvokeRequired)
            {
                Action<int> DoAction = delegate(int i) { RemoveAt(i); };
                listBox.Invoke(DoAction, new object[] { Index });
            }
            else
                listBox.Items.RemoveAt(Index);
        }
        public int GetItemCount()
        {
            return listBox.Items.Count;
        }
        public void SetSelectedIndex(int Index)
        {
            if (listBox.InvokeRequired)
            {
                Action<int> StringAction = delegate(int i) { SetSelectedIndex(i); };
                listBox.Invoke(StringAction, new object[] { Index });
            }
            else
                listBox.SelectedIndex = Index;
        }
    }

    class ListBoxLogger : Logger
    {
        ThreadSaveListBox lbLog;
        bool Follow;
        string CurrentLine;
        public ListBoxLogger(ListBox lbLog)
        {
            this.lbLog = new ThreadSaveListBox(lbLog);
            this.Follow = true;
            Clear();
        }
        public void Clear()
        {
            lbLog.Clear();
            // At least one empty line is needed
            CurrentLine = "";
            lbLog.AddItem("");
            if (Follow)
                lbLog.SetSelectedIndex(lbLog.GetItemCount() - 1);
        }
        public void SetFollow(bool Follow)
        {
            this.Follow = Follow;
            if (Follow)
            {
                lbLog.SetItem(lbLog.GetItemCount() - 1, CurrentLine);
                lbLog.SetSelectedIndex(lbLog.GetItemCount() - 1);
            }
        }
        public void NewLine()
        {
            if (!Follow)
                lbLog.SetItem(lbLog.GetItemCount() - 1,CurrentLine);
            CurrentLine = "";
            lbLog.AddItem("");
            if (Follow)
                lbLog.SetSelectedIndex(lbLog.GetItemCount() - 1);
        }
        public override void Write(string Text)
        {
            if (Text == null)
                return;
            if (Text == "")
                return;
            for (int i = 0; i < Text.Length; i++)
                if (Text[i] == '\b')
                {
                    if (CurrentLine.Length > 0)
                        CurrentLine = CurrentLine.Substring(0, CurrentLine.Length - 1);
                }
                else
                    CurrentLine += Text[i];
            if (Follow)
                lbLog.SetItem(lbLog.GetItemCount() - 1, CurrentLine);
        }
        public override void WriteLine(string Text)
        {
            Write(Text);
            while (lbLog.GetItemCount() > 10000)
                lbLog.RemoveAt(0);
            NewLine();
        }
        public void Dump(byte[] Data, int Offset, int Count)
        {
            Write(Count.ToString() + ":");
            for (int i = 0; i < Count; i++)
                Write(" " + Data[Offset+i].ToString("X2"));
            NewLine();
        }
        public void Dump(byte[] Data)
        {
            Dump(Data, 0, Data.Length);
        }
    }
}

